function [boxes,boxes_parts,time] = get_face_dpm_mvfd(inputImage,threshold,intervals,scale,show)
% [boxes,boxes_parts,time] = GET_FACE_DPM_MVFD(im,thresh,intervals,scale,show)
% 
% This function implements the Multi-View Face Detector by J. Orozco & M.
% Pantic using a Deformable Part Model.
% 
% Inputs:
%     - inputImage: image to test
%     - threshold: detection threshold to query the image, e.g. -1
%     - intervals: to compute an image pyramid, [1,10]
%     - scale: the option to scale up or down the image, [1/2,1,2]
%     - show: {0,1} whether to display output detecions or not.
% 
%  Outputs:
%     - boxes: bounding boxes as [xmin,ymin,xmax,ymax,model_component,detection_score]
%     - boxes_parts: bounding boxes of detected parts.
%     - time: clocking time spent on detection.
% 
% Copyright (C) 2015 Javier Orozco
% 
% ****Do not redistribute without permission****
% 
% ****For Research Purposes Only****
%  
% 
% Enjoy!
% 
% Javier Orozco
% drjo2009 (at) gmail.com
%